/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.mixins;

import fr.iglee42.evolvedmekanism.interfaces.EMInputRecipeCache;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.AbstractInputRecipeCache;
import mekanism.common.recipe.lookup.cache.TripleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.type.IInputCache;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TripleInputRecipeCache.class}, remap=false)
public class TripleInputRecipeCacheMixin<INPUT_A, INGREDIENT_A extends InputIngredient<INPUT_A>, INPUT_B, INGREDIENT_B extends InputIngredient<INPUT_B>, INPUT_C, INGREDIENT_C extends InputIngredient<INPUT_C>, RECIPE extends MekanismRecipe, CACHE_A extends IInputCache<INPUT_A, INGREDIENT_A, RECIPE>, CACHE_B extends IInputCache<INPUT_B, INGREDIENT_B, RECIPE>, CACHE_C extends IInputCache<INPUT_C, INGREDIENT_C, RECIPE>>
extends AbstractInputRecipeCache<RECIPE>
implements EMInputRecipeCache.IFindRecipes<INPUT_A, INGREDIENT_A, INPUT_B, INGREDIENT_B, INPUT_C, INGREDIENT_C, RECIPE, CACHE_A, CACHE_B, CACHE_C> {
    @Shadow
    @Final
    private CACHE_A cacheA;
    @Shadow
    @Final
    private CACHE_B cacheB;
    @Shadow
    @Final
    private CACHE_C cacheC;
    @Shadow
    @Final
    private Function<RECIPE, INGREDIENT_C> inputCExtractor;
    @Shadow
    @Final
    private Set<RECIPE> complexRecipes;
    @Shadow
    @Final
    private Function<RECIPE, INGREDIENT_A> inputAExtractor;
    @Shadow
    @Final
    private Function<RECIPE, INGREDIENT_B> inputBExtractor;

    protected TripleInputRecipeCacheMixin(MekanismRecipeType<RECIPE, ?> recipeType) {
        super(recipeType);
    }

    @Override
    @Nullable
    public RECIPE findTypeBasedRecipe(@Nullable Level world, INPUT_A inputA, INPUT_B inputB, INPUT_C inputC, Predicate<RECIPE> matchCriteria) {
        this.initCacheIfNeeded(world);
        if (this.cacheA.isEmpty(inputA)) {
            return null;
        }
        if (this.cacheB.isEmpty(inputB)) {
            return null;
        }
        Predicate<Object> matchPredicate = this.cacheC.isEmpty(inputC) ? matchCriteria : recipe -> ((InputIngredient)this.inputCExtractor.apply(recipe)).testType(inputC) && matchCriteria.test(recipe);
        MekanismRecipe recipe2 = this.cacheA.findFirstRecipe(inputA, matchPredicate);
        if (recipe2 == null) {
            return (RECIPE)this.findFirstRecipe(this.complexRecipes, r -> ((InputIngredient)this.inputAExtractor.apply(r)).testType(inputA) && ((InputIngredient)this.inputBExtractor.apply(r)).testType(inputB) && matchPredicate.test(r));
        }
        return (RECIPE)recipe2;
    }

    @Unique
    protected void initCache(List<RECIPE> recipes) {
    }
}

